using System;
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;


namespace InfoRequest_calls_Web_Service {
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form {
        private SqlConnection cn;   
        private SqlCommand cmdStates;
        private SqlDataAdapter daStates;
        private DataTable dtStates; 
        private DataTable dtCities; 
        private SqlCommand cmdCities;         
        private SqlDataAdapter daCities;
        private bool bCitiesSetup;  
        private SqlCommand cmdCustomers;
        private SqlDataAdapter daCustomers;
        private DataSet dsCustomers; 
        private DataSet dsInfoRequest; 
        private SqlCommand cmdOrderItem; 
        private SqlDataAdapter daOrderItem;
        private DataSet dsOrderItem; 

        private DataRow dRow; 
        private bool bSetup; 

        private int lCustSelected; 

        private string sISBNSelected;
        private string sCitySelected;
        private string sStateSelected;


        internal System.Windows.Forms.Button btnFilter;
        internal System.Windows.Forms.ComboBox cmbCities;
        internal System.Windows.Forms.TextBox NameHint;
        internal System.Windows.Forms.DataGrid dgCustomers;
        internal System.Windows.Forms.GroupBox DataIOButtons;
        internal System.Windows.Forms.RadioButton RadioButton1;
        internal System.Windows.Forms.RadioButton IOType;
        internal System.Windows.Forms.MenuItem MenuItem2;
        internal System.Windows.Forms.Label ZipForCity;
        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.Label Label3;
        internal System.Windows.Forms.Label Label2;
        internal System.Windows.Forms.DataGrid dgOrderItem;
        internal System.Windows.Forms.ComboBox cmbStateWanted;
        internal System.Windows.Forms.MainMenu MainMenu1;
        internal System.Windows.Forms.MenuItem MenuItem1;
        internal System.Windows.Forms.DataGrid dgInfoRequest;
        internal System.Windows.Forms.Button btnUpdate;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1() {
            try{
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //
                cn = new SqlConnection("server=.;database=biblio;uid=admin;pwd=pw");
                cmdStates = new SqlCommand("SELECT State, StateCode FROM ValidStates", cn);
                daStates = new SqlDataAdapter(cmdStates);
                dtStates = new DataTable();
                dtCities = new DataTable();
                cmdCities = new SqlCommand("SELECT DISTINCT City + ' : ' + Zip AS CityZip" +
                    " from Addresses where StateCode = @StateWanted order by CityZip", cn);
                daCities = new SqlDataAdapter(cmdCities);
                bCitiesSetup = true;
                cmdCustomers = new SqlCommand("GetCustomerByState", cn);
                daCustomers = new SqlDataAdapter(cmdCustomers);
                dsCustomers = new DataSet();
                cmdOrderItem = new SqlCommand("GetOrdersItemsByCustomer", cn);
                daOrderItem = new SqlDataAdapter(cmdOrderItem);
                dsOrderItem = new DataSet();
                dsInfoRequest= new DataSet("InfoRequest");

            }
            catch( Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }


        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.btnFilter = new System.Windows.Forms.Button();
            this.cmbCities = new System.Windows.Forms.ComboBox();
            this.NameHint = new System.Windows.Forms.TextBox();
            this.dgCustomers = new System.Windows.Forms.DataGrid();
            this.DataIOButtons = new System.Windows.Forms.GroupBox();
            this.RadioButton1 = new System.Windows.Forms.RadioButton();
            this.IOType = new System.Windows.Forms.RadioButton();
            this.MenuItem2 = new System.Windows.Forms.MenuItem();
            this.ZipForCity = new System.Windows.Forms.Label();
            this.Label1 = new System.Windows.Forms.Label();
            this.Label3 = new System.Windows.Forms.Label();
            this.Label2 = new System.Windows.Forms.Label();
            this.dgOrderItem = new System.Windows.Forms.DataGrid();
            this.cmbStateWanted = new System.Windows.Forms.ComboBox();
            this.MainMenu1 = new System.Windows.Forms.MainMenu();
            this.MenuItem1 = new System.Windows.Forms.MenuItem();
            this.dgInfoRequest = new System.Windows.Forms.DataGrid();
            this.btnUpdate = new System.Windows.Forms.Button();
            ((System.ComponentModel.ISupportInitialize)(this.dgCustomers)).BeginInit();
            this.DataIOButtons.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.dgOrderItem)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.dgInfoRequest)).BeginInit();
            this.SuspendLayout();
            // 
            // btnFilter
            // 
            this.btnFilter.Location = new System.Drawing.Point(288, 124);
            this.btnFilter.Name = "btnFilter";
            this.btnFilter.Size = new System.Drawing.Size(120, 24);
            this.btnFilter.TabIndex = 23;
            this.btnFilter.Text = "Filter Customers";
            this.btnFilter.Click += new System.EventHandler(this.btnFilter_Click);
            // 
            // cmbCities
            // 
            this.cmbCities.DropDownWidth = 232;
            this.cmbCities.Location = new System.Drawing.Point(16, 76);
            this.cmbCities.Name = "cmbCities";
            this.cmbCities.Size = new System.Drawing.Size(232, 21);
            this.cmbCities.TabIndex = 22;
            this.cmbCities.SelectedIndexChanged += new System.EventHandler(this.cmbCities_SelectedIndexChanged);
            // 
            // NameHint
            // 
            this.NameHint.Location = new System.Drawing.Point(16, 124);
            this.NameHint.MaxLength = 50;
            this.NameHint.Name = "NameHint";
            this.NameHint.Size = new System.Drawing.Size(232, 20);
            this.NameHint.TabIndex = 21;
            this.NameHint.Text = "";
            this.NameHint.Validating += new System.ComponentModel.CancelEventHandler(this.NameHint_Validating);
            // 
            // dgCustomers
            // 
            this.dgCustomers.DataMember = "";
            this.dgCustomers.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.dgCustomers.Location = new System.Drawing.Point(0, 164);
            this.dgCustomers.Name = "dgCustomers";
            this.dgCustomers.Size = new System.Drawing.Size(592, 176);
            this.dgCustomers.TabIndex = 20;
            this.dgCustomers.Click += new System.EventHandler(this.dgCustomers_Click);
            this.dgCustomers.CurrentCellChanged += new System.EventHandler(this.dgCustomers_CurrentCellChanged);
            // 
            // DataIOButtons
            // 
            this.DataIOButtons.BackColor = System.Drawing.SystemColors.Desktop;
            this.DataIOButtons.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                                        this.RadioButton1,
                                                                                        this.IOType});
            this.DataIOButtons.Location = new System.Drawing.Point(440, 4);
            this.DataIOButtons.Name = "DataIOButtons";
            this.DataIOButtons.Size = new System.Drawing.Size(128, 72);
            this.DataIOButtons.TabIndex = 18;
            this.DataIOButtons.TabStop = false;
            this.DataIOButtons.Text = "Data IO Technique";
            // 
            // RadioButton1
            // 
            this.RadioButton1.Checked = true;
            this.RadioButton1.Location = new System.Drawing.Point(16, 40);
            this.RadioButton1.Name = "RadioButton1";
            this.RadioButton1.Size = new System.Drawing.Size(88, 24);
            this.RadioButton1.TabIndex = 6;
            this.RadioButton1.TabStop = true;
            this.RadioButton1.Text = "Fill";
            // 
            // IOType
            // 
            this.IOType.Location = new System.Drawing.Point(16, 16);
            this.IOType.Name = "IOType";
            this.IOType.Size = new System.Drawing.Size(88, 24);
            this.IOType.TabIndex = 5;
            this.IOType.Text = "DataReader";
            // 
            // MenuItem2
            // 
            this.MenuItem2.Index = 0;
            this.MenuItem2.Text = "E&xit";
            this.MenuItem2.Click += new System.EventHandler(this.MenuItem2_Click);
            // 
            // ZipForCity
            // 
            this.ZipForCity.Location = new System.Drawing.Point(264, 76);
            this.ZipForCity.Name = "ZipForCity";
            this.ZipForCity.Size = new System.Drawing.Size(128, 24);
            this.ZipForCity.TabIndex = 17;
            // 
            // Label1
            // 
            this.Label1.Location = new System.Drawing.Point(16, 4);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(168, 16);
            this.Label1.TabIndex = 14;
            this.Label1.Text = "States";
            // 
            // Label3
            // 
            this.Label3.Location = new System.Drawing.Point(16, 60);
            this.Label3.Name = "Label3";
            this.Label3.Size = new System.Drawing.Size(168, 16);
            this.Label3.TabIndex = 15;
            this.Label3.Text = "Cities";
            // 
            // Label2
            // 
            this.Label2.Location = new System.Drawing.Point(16, 108);
            this.Label2.Name = "Label2";
            this.Label2.Size = new System.Drawing.Size(168, 16);
            this.Label2.TabIndex = 16;
            this.Label2.Text = "Name hint";
            // 
            // dgOrderItem
            // 
            this.dgOrderItem.DataMember = "";
            this.dgOrderItem.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.dgOrderItem.Location = new System.Drawing.Point(0, 352);
            this.dgOrderItem.Name = "dgOrderItem";
            this.dgOrderItem.Size = new System.Drawing.Size(592, 184);
            this.dgOrderItem.TabIndex = 19;
            this.dgOrderItem.Click += new System.EventHandler(this.dgOrderItem_Click);
            this.dgOrderItem.DoubleClick += new System.EventHandler(this.dgOrderItem_DoubleClick);
            this.dgOrderItem.Navigate += new System.Windows.Forms.NavigateEventHandler(this.dgOrderItem_Navigate);
            // 
            // cmbStateWanted
            // 
            this.cmbStateWanted.DropDownWidth = 184;
            this.cmbStateWanted.Location = new System.Drawing.Point(16, 20);
            this.cmbStateWanted.Name = "cmbStateWanted";
            this.cmbStateWanted.Size = new System.Drawing.Size(240, 21);
            this.cmbStateWanted.Sorted = true;
            this.cmbStateWanted.TabIndex = 13;
            this.cmbStateWanted.SelectedIndexChanged += new System.EventHandler(this.cmbStateWanted_SelectedIndexChanged);
            // 
            // MainMenu1
            // 
            this.MainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                      this.MenuItem1});
            // 
            // MenuItem1
            // 
            this.MenuItem1.Index = 0;
            this.MenuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                      this.MenuItem2});
            this.MenuItem1.Text = "&File";
            // 
            // dgInfoRequest
            // 
            this.dgInfoRequest.DataMember = "";
            this.dgInfoRequest.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.dgInfoRequest.Location = new System.Drawing.Point(8, 544);
            this.dgInfoRequest.Name = "dgInfoRequest";
            this.dgInfoRequest.Size = new System.Drawing.Size(488, 104);
            this.dgInfoRequest.TabIndex = 24;
            // 
            // btnUpdate
            // 
            this.btnUpdate.Location = new System.Drawing.Point(512, 568);
            this.btnUpdate.Name = "btnUpdate";
            this.btnUpdate.Size = new System.Drawing.Size(72, 56);
            this.btnUpdate.TabIndex = 25;
            this.btnUpdate.Text = "Submit Request";
            this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(592, 657);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.btnUpdate,
                                                                          this.dgInfoRequest,
                                                                          this.cmbCities,
                                                                          this.NameHint,
                                                                          this.dgCustomers,
                                                                          this.DataIOButtons,
                                                                          this.ZipForCity,
                                                                          this.Label1,
                                                                          this.Label3,
                                                                          this.Label2,
                                                                          this.dgOrderItem,
                                                                          this.cmbStateWanted,
                                                                          this.btnFilter});
            this.Menu = this.MainMenu1;
            this.Name = "Form1";
            this.Text = "Form1";
            this.Load += new System.EventHandler(this.Form1_Load);
            ((System.ComponentModel.ISupportInitialize)(this.dgCustomers)).EndInit();
            this.DataIOButtons.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.dgOrderItem)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.dgInfoRequest)).EndInit();
            this.ResumeLayout(false);

        }
#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() {
            Application.Run(new Form1());
        }

        private void Form1_Load(object sender, System.EventArgs e) {
            try{
                int ltic = Environment.TickCount;

                SetupCommands();
                ShowTime(ltic, "Load");
            }
            catch( Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }

        private void SetupCommands() {
            try{
                cmdCities.Parameters.Add("@StateWanted", SqlDbType.VarChar, 2);

                cmdCustomers.CommandType = CommandType.StoredProcedure;
                cmdCustomers.Parameters.Add("@ZipWanted", SqlDbType.VarChar, 10);
                cmdCustomers.Parameters.Add("@NameHint", SqlDbType.VarChar, 50);
                cmdCustomers.Parameters["@NameHint"].Value = "%";              // Default to all names



                cmdOrderItem.CommandType = CommandType.StoredProcedure;
                cmdOrderItem.Parameters.Add("@CustIDWanted", SqlDbType.Int);

                daOrderItem.TableMappings.Add("Table", "Orders");
                daOrderItem.TableMappings.Add("Table1", "Items");


                daStates.Fill(dtStates);             // Fill ValidStates combo box

                bSetup = true;                        // Turn off "change" operations on combo
                cmbStateWanted.DataSource = dtStates;
                cmbStateWanted.DisplayMember = "State";

                bSetup = false;                       // Enable change operations on combo
            }
            catch( Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }
        private void ShowTime(int lStartTick, string sTimerWhen) {
            try{
                Debug.WriteLine(DateTime.Now + ":" + sTimerWhen + " " + Convert.ToString(Environment.TickCount - lStartTick));
            }
            catch( Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }

        private void cmbStateWanted_SelectedIndexChanged(object sender, System.EventArgs e) {
            try {
                ShowCitiesInState(cn);
            }
            catch( Exception ex){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }
        private void ShowCitiesInState( SqlConnection cn ) {
            try{
                DataTable dtCities = new DataTable();
                int TimerStart = Environment.TickCount;
                // Column names are case-sensitive!
                if (bSetup) { 
                    return;
                }
                DataIOButtons.Enabled = false;
                this.Cursor = Cursors.WaitCursor;
                cmbCities.Enabled = true;

                dRow = dtStates.Rows[Convert.ToInt32(cmbStateWanted.SelectedIndex)];
                cmdCities.Parameters[0].Value = dRow["StateCode"].ToString();
                Debug.WriteLine("State selected:" + dRow["StateCode"].ToString());

                sStateSelected = cmbStateWanted.Text;

                if (IOType.Checked == false) {
                    // DataReader or DataSet?

                    daCities.Fill(dtCities);
                    if (dtCities.Rows.Count > 0 ) {
                        bCitiesSetup = true;
                        cmbCities.DataSource = dtCities;
                        cmbCities.DisplayMember = "CityZip";
                        bCitiesSetup = false;
                        // Must match column name in SQL exactly -- case-sensitive unless you set CaseSensitive property
                    }
                    else {
                        cmbCities.DataSource = null;
                        cmbCities.Items.Clear();
                        cmbCities.Text = "(No customers on file for this state)";
                        cmbCities.Refresh();
                        cmbCities.Enabled = false;
                    }


                    ShowTime(TimerStart, " Fill combo");
                }
                else {
                    // Request for DataReader
                    ReadCities();
                    ShowTime(TimerStart, " DataReader loop load combo");
                    bCitiesSetup = false;
                }
            }
            catch( Exception ex){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
            finally {
                this.Cursor = Cursors.Default;
            }
        }
        private void ReadCities() {
            try{
                // Fill using a DataReader
                SqlDataReader drCities; 
                string sCity;
                if (cn.State == ConnectionState.Closed) {
                    cn.Open();
                }

                drCities = cmdCities.ExecuteReader(CommandBehavior.SingleResult);
                drCities.Read();
                cmbCities.BeginUpdate();
                cmbCities.DataSource = null;
                cmbCities.DisplayMember = "";
                cmbCities.Items.Clear();
                while (drCities.Read() ) {
                    sCity = drCities.GetString(0);
                    cmbCities.Items.Add(sCity);
                }
                drCities.Close();
                cn.Close();
                drCities = null; // Release any previous DataReader
                if (cmbCities.Items.Count == 0) {
                    cmbCities.Text = "(No customers on file for this state)";
                    cmbCities.Refresh();
                    cmbCities.Enabled = false;
                }
                else {
                    cmbCities.SelectedIndex = 0;
                }

                cmbCities.EndUpdate();
            }
            catch( Exception ex){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void cmbCities_SelectedIndexChanged(object sender, System.EventArgs e) {
            try{
                ShowCustomersInCity(dgCustomers, cn);
            }

            catch( Exception ex){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void dgCustomers_Click(object sender, System.EventArgs e) {
            try{
                ShowOrderItemData(dgOrderItem, cn);
            }

            catch( Exception ex){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void dgCustomers_CurrentCellChanged(object sender, System.EventArgs e) {
            try{
                ShowOrderItemData(dgOrderItem, cn);
            }
            catch( Exception ex ){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void btnFilter_Click(object sender, System.EventArgs e) {
            try{
                NameHint.Text = NameHint.Text.Replace("*", "%");
                if (NameHint.Text.Length == 0) {
                    NameHint.Text = "%" ;
                }
            }
            catch( Exception ex){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void ShowCustomersInCity( DataGrid dg, SqlConnection cn) {
            try{
                if (bCitiesSetup) { 
                    return; }
                this.Cursor = Cursors.WaitCursor;

                if (cmbCities.Text.IndexOf( ":") == 0) { 
                    return;
                }
                sCitySelected = cmbCities.Text.Substring(0, cmbCities.Text.IndexOf(" : ") ).ToString();
                ZipForCity.Text = cmbCities.Text.Substring( cmbCities.Text.IndexOf( " : ") + 3).ToString();


                if (dsCustomers.Tables.Count > 0 ) {
                    dsCustomers = new DataSet();
                }

                cmdCustomers.Parameters["@ZipWanted"].Value = ZipForCity.Text;
                if (NameHint.Text.IndexOf("%") < 0) {
                    NameHint.Text += "%" ;
                }

                if (NameHint.Text.Length > 0) { 
                    cmdCustomers.Parameters["@NameHint"].Value = NameHint.Text;
                    daCustomers.Fill(dsCustomers, "Customers");          // dsCustomers (DataSet must be instantiated (Dim as New))
                    dg.DataSource = dsCustomers.Tables[0];
                    dg.CaptionText = "Customers in " + sCitySelected;
                }
            }
            catch( Exception ex){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
            finally{
                this.Cursor = Cursors.Default;
            }

        }

        private void ShowOrderItemData( DataGrid dg,  SqlConnection cn) {
            try {
                dgInfoRequest.DataSource = null;
                int lRow = dgCustomers.CurrentCell.RowNumber;
                int lCol = dgCustomers.CurrentCell.ColumnNumber;
                int lCurRow = dgCustomers.CurrentRowIndex;
                int lCustID = Convert.ToInt32(dgCustomers[lRow, 0]);

                SqlDataAdapter da = new SqlDataAdapter();
                SqlCommand sc = new SqlCommand();
            
                DataColumn[] ParentCols = new DataColumn[2]; 
                DataColumn[] ChildCols = new DataColumn[2];
                DataRelation relPublishers; 
                lCustSelected = lCustID;

                sc.CommandText = "GetOrdersItemsByCustomer";
                sc.CommandType = CommandType.StoredProcedure;
                sc.Parameters.Add("@CustIDWanted", SqlDbType.Int).Value = lCustID;
                sc.Connection = cn;

                da.SelectCommand = sc;
                da.TableMappings.Add("Table", "Orders");
                da.TableMappings.Add("Table1", "Items");

                dg.PreferredColumnWidth = 100;
                dsOrderItem = new DataSet();                
                da.Fill(dsOrderItem);
                ParentCols[0] = dsOrderItem.Tables["Orders"].Columns["CustID"];
                ParentCols[1] = dsOrderItem.Tables["Orders"].Columns["OrderID"];

                ChildCols[0] = dsOrderItem.Tables["Items"].Columns["CustID"];
                ChildCols[1] = dsOrderItem.Tables["Items"].Columns["OrderID"];

                // Create DataRelation.
                bool bConstraints = true;
                relPublishers = new DataRelation("OrderItem", ParentCols, ChildCols, bConstraints);

                // Add the relation to the DataSet.
                dsOrderItem.Relations.Add(relPublishers);
                dg.DataSource = null;
                dg.DataSource = dsOrderItem.Tables[0];
            }
            catch( Exception ex){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void NameHint_Validating(object sender, System.ComponentModel.CancelEventArgs e) {
            try{
                NameHint.Text = NameHint.Text.Replace("*", "%");
                ShowCustomersInCity(dgCustomers, cn);
            }
            catch( Exception ex){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void MenuItem2_Click(object sender, System.EventArgs e) {
            try{
                this.Close();
            }
            catch( Exception ex){
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void btnUpdate_Click(object sender, System.EventArgs e) {
            localhost.UpdateInfoRequestClass UpdateInfoRequest;
            try{
                UpdateInfoRequest = new localhost.UpdateInfoRequestClass();
                if( dsInfoRequest.HasChanges()) {
                    dsInfoRequest = UpdateInfoRequest.UpdateInfoRequest(dsInfoRequest);
                    if (dsInfoRequest.HasErrors) {
                        MessageBox.Show("Update failed...");
                        dgInfoRequest.Refresh();
                    }
                }
            }
            catch ( Exception exg2 ) {
                MessageBox.Show(exg2.ToString());
                Debug.WriteLine(exg2.ToString());
            }
        }

        private void dgOrderItem_Navigate(object sender, System.Windows.Forms.NavigateEventArgs ne) {
            try{   
                SqlDataAdapter da = new SqlDataAdapter("SELECT * FROM InfoRequest WHERE CustID = @CustID", cn);
                DataTable dt;
                da.SelectCommand.Parameters.Add("@CustID", lCustSelected);
                dsInfoRequest.Clear();
                da.Fill(dsInfoRequest, "InfoRequest");
                dt = dsInfoRequest.Tables[0];
                dgInfoRequest.DataSource = dt;
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void dgOrderItem_Click(object sender, System.EventArgs e) {
            try{
                   
                DataGridCell dgCell  = dgOrderItem.CurrentCell;
                DataTable dt = dsOrderItem.Tables["Items"];
                sISBNSelected = dt.Rows[dgCell.RowNumber]["ISBN"].ToString();
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void dgOrderItem_DoubleClick(object sender, System.EventArgs e) {
            try{
                DataRow dr = dsInfoRequest.Tables[0].NewRow();
                dr["CustID"] = lCustSelected;
                dr["DateRequested"] = System.DateTime.Now;
                dr["ISBN"] = sISBNSelected;
                dsInfoRequest.Tables[0].Rows.Add(dr);
                dgInfoRequest.Refresh();
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }
    }
}
